/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.DoggyTags;
import doggytalents.api.feature.FoodHandler;
import doggytalents.common.entity.DogEntity;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public class DogBegGoal
extends Goal {
    private final DogEntity dog;
    private PlayerEntity player;
    private final World world;
    private final float minPlayerDistance;
    private int timeoutCounter;
    private final EntityPredicate playerPredicate;

    public DogBegGoal(DogEntity wolf, float minDistance) {
        this.dog = wolf;
        this.world = wolf.field_70170_p;
        this.minPlayerDistance = minDistance;
        this.playerPredicate = new EntityPredicate().func_221013_a((double)minDistance).func_221008_a().func_221011_b().func_221009_d();
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        this.player = this.world.func_217370_a(this.playerPredicate, (LivingEntity)this.dog);
        return this.player == null ? false : this.hasTemptationItemInHand(this.player);
    }

    public boolean func_75253_b() {
        if (!this.player.func_70089_S()) {
            return false;
        }
        if (this.dog.func_70068_e((Entity)this.player) > (double)(this.minPlayerDistance * this.minPlayerDistance)) {
            return false;
        }
        return this.timeoutCounter > 0 && this.hasTemptationItemInHand(this.player);
    }

    public void func_75249_e() {
        this.dog.setBegging(true);
        this.timeoutCounter = 40 + this.dog.func_70681_au().nextInt(40);
    }

    public void func_75251_c() {
        this.dog.setBegging(false);
        this.player = null;
    }

    public void func_75246_d() {
        this.dog.func_70671_ap().func_75650_a(this.player.func_226277_ct_(), this.player.func_226280_cw_(), this.player.func_226281_cx_(), 10.0f, (float)this.dog.func_70646_bf());
        --this.timeoutCounter;
    }

    private boolean hasTemptationItemInHand(PlayerEntity player) {
        for (Hand hand : Hand.values()) {
            ItemStack itemstack = player.func_184586_b(hand);
            if (itemstack.func_77973_b().func_206844_a(this.dog.func_70909_n() ? DoggyTags.BEG_ITEMS_TAMED : DoggyTags.BEG_ITEMS_UNTAMED)) {
                return true;
            }
            if (itemstack.func_77973_b().func_206844_a(DoggyTags.TREATS)) {
                return true;
            }
            if (FoodHandler.isFood(itemstack).isPresent()) {
                return true;
            }
            if (!this.dog.func_70877_b(itemstack)) continue;
            return true;
        }
        return false;
    }
}

